//Register PWA service worker
if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('sw.js');
}
//Redirect HTTP to HTTPS
if(location.protocol=="http:"){
    location.href="https"+location.href.substring(4);
}

//Example functions
function ID(e){
    return document.getElementById(e);
}
function getIP(){
    var xhr=new XMLHttpRequest();
    xhr.onerror=function(){
        ID("ipinfo").innerText="Errore";
    };
    xhr.onload=function(){
        try{
            var ipinfo=ID("ipinfo");
            var data=JSON.parse(xhr.responseText);
            ipinfo.innerHTML="";
            var d=document.createElement("div");
            d.innerText=data.processedString;
            ipinfo.appendChild(d);
            var d=document.createElement("div");
            d.style.fontSize="0.8em";
            d.style.marginTop="1rem";
            d.innerText=JSON.stringify(data);
            ipinfo.appendChild(d);
        }catch(e){
            ID("ipinfo").innerText="Errore";
        }
    }
    var isp=ID("isp").value, distance=ID("distance").value;
    var req="?cors=true";
    if(isp!="no"){
        req+="&isp="+encodeURIComponent(isp);
    }
    if(distance!="no"){
        req+="&distance="+encodeURIComponent(distance);
    }
    req+="&random="+encodeURIComponent(Math.random());
    xhr.open("GET","https://st-be-rm2.infra.garr.it/getIP.php"+req,true);
    xhr.send();
    ID("ipinfo").innerText="Un attimo...";
}
