const cacheName='pwaes4';
const appFiles=[
    'index.html',
    'app.js',
    'favicon.png',
    'manifest.json',
    'pwaicon.png',
    'style.css',
    'sw.js',
    'songs/list.json'
];

// Caches all the PWA shell files (appFiles array) when the app is launched
self.addEventListener('install', (e) => {
  console.log('[Service Worker] Install');
  const filesUpdate = cache => {
      const stack = [];
      appFiles.forEach(file => stack.push(
          cache.add(file).catch(_=>console.error(`can't load ${file} to cache`))
      ));
      return Promise.all(stack);
  };
  e.waitUntil(caches.open(cacheName).then(filesUpdate));
});

// Called when the app fetches a resource like an image, caches it automatically (based on another version found in the cache api documentation)
self.addEventListener('fetch', function(event) {
  event.respondWith(
    caches.open(cacheName).then(function(cache) {
      return cache.match(event.request).then(function(response) {
        if (response) {
          console.log("[Service Worker] Serving from cache: "+event.request.url);
          return response;
        }
        console.log("[Service Worker] Fetching: "+event.request.url);
        if(event.request.url.endsWith(".opus")){
          cache.add(event.request.url);
          return fetch(event.request.clone());
        }
        return fetch(event.request.clone()).then(function(response) {
          if (response.status < 400 ){
            console.log("[Service Worker] Cached: "+event.request.url);
            cache.put(event.request, response.clone());
          }
          return response;
        });
      }).catch(function(error) {
        console.log("[Service Worker] Error: "+event.request.url);
        throw error;
      });
    })
  );
});

// Called when the service worker is started
self.addEventListener('activate', (e) => {
    console.log("[Service Worker] Activated");
});
