//Register PWA service worker
if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('sw.js');
}
//Redirect HTTP to HTTPS
if(location.protocol=="http:"){
    location.href="https"+location.href.substring(4);
}


function ID(e){
    return document.getElementById(e);
}
function salvaNota(id,titolo,testo){
    var note=[];
    try{
        note=JSON.parse(localStorage.note);
    }catch(e){}
    if(!note) note=[];
    var n={"titolo":titolo,"testo":testo};
    if(id=="nuova"){
        note.push(n);
    }else{
        note[id]=n;
    }
    localStorage.note=JSON.stringify(note);
}
function eliminaNota(id){
    if(!localStorage.note) return;
    try{
        var note=[];
        note=JSON.parse(localStorage.note);
        note.splice(id,1);
        localStorage.note=JSON.stringify(note);
    }catch(e){}
}
function caricaNota(id){
    if(!localStorage.note) return;
    try{
        return JSON.parse(localStorage.note)[Number(id)]; 
    }catch(e){
        return {"titolo":"","testo":""};
    }
}


function aggiornaLista(){
    var lista=ID("lista");
    lista.innerHTML="";
    try{
        var note=JSON.parse(localStorage.note);
        if(note.length==0) throw "";
        for(var i=0;i<note.length;i++){
            try{
                var link=document.createElement("a");
                link.onclick=function(id){
                    return function(){
                        modifica(id);
                    }.bind(this);
                }(i);
                link.innerText=note[i].titolo;
                lista.appendChild(link);
            }catch(e){};
        }
    }catch(e){
        lista.innerText="Nessuna nota inserita";
    }
}
function nuovaNota(){
    modifica("nuova");
}
function modifica(id){
    if(id!="nuova"){
        var n=caricaNota(id);
        ID("titoloNota").value=n.titolo;
        ID("testoNota").value=n.testo;
        ID("cancella").style.display="initial";
    }else{
        ID("titoloNota").value="Nota del "+new Date().toLocaleString();
        ID("testoNota").value="";
        ID("cancella").style.display="none";
    }
    ID("salva").onclick=function(){
        salvaNota(id,ID("titoloNota").value,ID("testoNota").value);
        ID("modifica").className="nascosto";
        aggiornaLista();
    };
    ID("cancella").onclick=function(){
        if(confirm("Sicuro?")){
            eliminaNota(id);
            ID("modifica").className="nascosto";
            aggiornaLista();
        }
    }
    ID("annulla").onclick=function(){
        ID("modifica").className="nascosto";
    }
    ID("modifica").className="visibile";
}
