//Register PWA service worker
if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('sw.js');
}

//Example functions
function ID(e){
    return document.getElementById(e);
}
function getPWADisplayMode() {
    if (document.referrer.startsWith('android-app://')) {
        return 'twa';
    } else if (navigator.standalone || window.matchMedia('(display-mode: standalone)').matches) {
        return 'standalone';
    }
    return 'browser';
}
function getURL(){
    return document.URL;
}
function getProtocol(){
    return location.protocol;
}
function getUserAgent(){
    return navigator.userAgent;
}
function isServiceWorkerRunning(){
    if('serviceWorker' in navigator){
        return !(navigator.serviceWorker.controller===null);
    }else{
        return false;
    }
}
function isOnline(){
    return navigator.onLine;
}
function getConnectionType(){
    if(navigator.connection){
        if(navigator.connection.type){
            return navigator.connection.type;
        }else{
            return navigator.connection.effectiveType;
        }
    }else return "unknown";
}
function testConnection(success,failure){
    var xhr=new XMLHttpRequest();
    xhr.onload=function(){
        success();
    };
    xhr.onerror=function(){
        failure();
    }
    xhr.open("GET","test.dat?r="+Math.random(),true);
    xhr.send();
}
function getPreferredColorScheme(){
    if(window.matchMedia){
        if(window.matchMedia("(prefers-color-scheme:dark)").matches){
            return "dark";
        }else{
            return "light";
        }
    }else{
        return "light";
    }
}
function isNotificationsAllowed(){
    if(window.Notification){
        return Notification.permission==="granted";
    }else{
        return false;
    }
}
function getGPSLocation(success,failure){
    if(navigator.geolocation){
        navigator.geolocation.getCurrentPosition(function(pos){
           success(pos.coords);
        },function(e){
            failure();
        });
    }else{
        failure();
    }
}
function getLastAppLaunchTimestamp(){
    if(localStorage.lastLaunchedAt){
        return localStorage.lastLaunchedAt;
    }else{
        return null;
    }
}
function updateLastAppLaunchTimestamp(){
    localStorage.lastLaunchedAt=new Date();
}
